# WiFi Router Admin Panel

This is a Go web application that simulates a WiFi router's administrative interface. The app provides a simple web UI for managing router settings, viewing connected devices, and configuring user accounts.

## What's Included

This interview bundle contains:

- **`cmd/router/`** - Main application entry point
- **`internal/`** - Core application logic (database, handlers, models)
- **`templates/`** - HTML templates for the web interface
- **`static/`** - CSS stylesheets and static assets
- **Go modules** - `go.mod` and `go.sum` for dependency management
- **Dockerfile** - Container configuration

## Application Overview

The router admin panel includes typical features you'd find in a home WiFi router interface:

- User authentication and login
- Dashboard showing router status
- Connected devices management
- User account management
- Network settings configuration
- Device ping functionality

The application uses SQLite for data storage and standard Go libraries for the web server implementation.
