package main

import (
	"fmt"
	"log"
	"net/http"

	"github.com/sourcegraph/security-coding-interview/internal/database"
	"github.com/sourcegraph/security-coding-interview/internal/handlers"
)

func main() {
	router := database.NewRouter()
	handler := handlers.NewHandler(router)

	http.HandleFunc("/", handler.LoginPage)
	http.HandleFunc("/login", handler.Login)
	http.HandleFunc("/dashboard", handler.Dashboard)
	http.HandleFunc("/users", handler.Users)
	http.HandleFunc("/user/", handler.UserProfile)
	http.HandleFunc("/ping", handler.Ping)
	http.HandleFunc("/settings", handler.Settings)
	http.HandleFunc("/logout", handler.Logout)
	http.HandleFunc("/download", handler.Download)
	http.Handle("/static/", http.StripPrefix("/static/", http.FileServer(http.Dir("static/"))))

	fmt.Println("WiFi Router Admin Panel running on http://localhost:9992")
	log.Fatal(http.ListenAndServe(":9992", nil))
}
