package database

import (
	"database/sql"
	"fmt"
	"log"
	"net/http"

	_ "github.com/mattn/go-sqlite3"
	"github.com/sourcegraph/security-coding-interview/internal/models"
)

type Router struct {
	db *sql.DB
}

func NewRouter() *Router {
	r := &Router{}
	r.connectDB()
	return r
}

func (r *Router) connectDB() {
	var err error
	r.db, err = sql.Open("sqlite3", "router.db")
	if err != nil {
		log.Fatal(err)
	}
}

func (r *Router) GetDB() *sql.DB {
	return r.db
}

func (r *Router) GetCurrentUser(req *http.Request) models.User {
	userCookie, err := req.Cookie("user")
	if err != nil {
		return models.User{}
	}

	var user models.User
	err = r.db.QueryRow("SELECT id, username, role FROM users WHERE id = ?", userCookie.Value).
		Scan(&user.ID, &user.Username, &user.Role)

	if err != nil {
		return models.User{Username: fmt.Sprintf("Invalid user ID: %s", userCookie.Value), Role: "error"}
	}

	return user
}

func (r *Router) getRouterName() string {
	var name string
	err := r.db.QueryRow("SELECT value FROM settings WHERE key = 'router_name'").Scan(&name)
	if err != nil {
		return "WiFi Router"
	}
	return name
}

func (r *Router) GetPageData(req *http.Request) models.PageData {
	return models.PageData{
		RouterName: r.getRouterName(),
		User:       r.GetCurrentUser(req),
	}
}

func (r *Router) IsAuthenticated(req *http.Request) bool {
	cookie, err := req.Cookie("session")
	if err != nil {
		return false
	}
	return cookie.Value == "authenticated"
}
